<?php
// Принудительно установить timezone
date_default_timezone_set('Europe/Chisinau');

// Загрузить WordPress
require_once(dirname(__FILE__) . '/wp-load.php');

echo "<h2>WordPress Time Configuration Test - promez.de</h2>";
echo "<style>table{border-collapse:collapse;width:100%} th,td{border:1px solid #ddd;padding:8px} th{background-color:#f2f2f2}</style>";
echo "<table>";
echo "<tr><th>Parameter</th><th>Value</th><th>Status</th></tr>";

// Системные настройки
$system_time = trim(shell_exec('date'));
$php_timezone = date_default_timezone_get();
$php_time = date('Y-m-d H:i:s T');

echo "<tr><td>System time</td><td>$system_time</td><td>✓</td></tr>";
echo "<tr><td>PHP timezone</td><td><strong>$php_timezone</strong></td><td>" . ($php_timezone === 'Europe/Chisinau' ? '✓' : '✗') . "</td></tr>";
echo "<tr><td>PHP time</td><td><strong>$php_time</strong></td><td>✓</td></tr>";

// WordPress настройки
$wp_timezone = get_option('timezone_string');
$wp_offset = get_option('gmt_offset');

echo "<tr><td>WP timezone string</td><td><strong>" . ($wp_timezone ?: 'Not set') . "</strong></td><td>" . ($wp_timezone === 'Europe/Chisinau' ? '✓' : '⚠') . "</td></tr>";
echo "<tr><td>WP GMT offset</td><td><strong>$wp_offset</strong></td><td>" . ($wp_offset == 3 ? '✓' : '⚠') . "</td></tr>";

// WordPress функции времени
if (function_exists('current_time')) {
    $wp_time = current_time('Y-m-d H:i:s T');
    $wp_timestamp = current_time('timestamp');
    echo "<tr><td>WP current_time()</td><td><strong>$wp_time</strong></td><td>✓</td></tr>";
    echo "<tr><td>WP timestamp</td><td>$wp_timestamp</td><td>✓</td></tr>";
}

echo "</table>";

echo "<h3>Email Test Simulation</h3>";
$mail_date = date('r'); // RFC format for email headers
echo "<p><strong>Email Date header:</strong> $mail_date</p>";
echo "<p><strong>WordPress time:</strong> " . (function_exists('current_time') ? current_time('Y-m-d H:i:s T') : date('Y-m-d H:i:s T')) . "</p>";

// Симуляция wp_mail
if (function_exists('wp_mail')) {
    echo "<h3>wp_mail() Test</h3>";
    echo "<div style='background:#f9f9f9;padding:10px;border:1px solid #ddd'>";
    echo "<strong>Test email headers would be:</strong><br>";
    echo "Date: " . date('r') . "<br>";
    echo "Subject: Test email - " . date('Y-m-d H:i:s T') . "<br>";
    echo "Content: Email sent at " . date('Y-m-d H:i:s T') . " (Europe/Chisinau timezone)<br>";
    echo "</div>";

    echo "<p style='color:green'>✓ wp_mail() function is available and will use correct timezone</p>";
} else {
    echo "<p style='color:red'>✗ wp_mail() function not available</p>";
}

echo "<h3>Recommendations</h3>";
if ($wp_timezone !== 'Europe/Chisinau') {
    echo "<p style='color:orange'>⚠ Рекомендуется установить в WordPress Admin → Settings → General → Timezone: 'Europe/Chisinau'</p>";
}
if ($php_timezone === 'Europe/Chisinau') {
    echo "<p style='color:green'>✓ PHP timezone настроен правильно</p>";
}
?>
