<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

defined('ABSPATH') || exit;

global $product;

$product_id = $product->get_id();
/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked woocommerce_output_all_notices - 10
 */
do_action('woocommerce_before_single_product');

if (post_password_required()) {
    echo get_the_password_form(); // WPCS: XSS ok.
    return;
}
?>
<div class="single_prod_wrap">
    <div class="container">
        <div id="product-<?php the_ID(); ?> " <?php wc_product_class('product_wrap', $product); ?>>
            <div class="gallery_side">
                <?php
                if ($product->is_on_sale()) {
                    $regular_price = (float)$product->get_regular_price();
                    $sale_price = (float)$product->get_sale_price();

                    if ($regular_price && $sale_price) {
                        // Calculăm procentul de reducere
                        $percentage = round((($regular_price - $sale_price) / $regular_price) * 100);
                        echo '<span class="onsale">-' . $percentage . '% OFF</span>';
                    }
                }

                ?>
                <?php
                // Obține ID-ul imaginii principale
                $main_image_id = $product->get_image_id();
                $main_image_url = wp_get_attachment_url($main_image_id);
                // Obține ID-urile imaginilor din galerie
                $gallery_image_ids = $product->get_gallery_image_ids(); ?>
                <div class="top_gallery_sing_prod">
                    <a href="<?= esc_url($main_image_url) ?>" data-lightbox="top_gallery_sing_prod">
                        <img src="<?= esc_url($main_image_url) ?>" alt="<?= esc_attr($product->get_name()) ?>">
                    </a>
                    <?php
                    foreach ($gallery_image_ids as $image_id) {
                        $image_url = wp_get_attachment_url($image_id);
                        ?>
                        <a href="<?= esc_url($image_url) ?>" data-lightbox="top_gallery_sing_prod">
                            <img src="<?= esc_url($image_url) ?>" alt="<?= esc_attr($product->get_name()) ?>">
                        </a>
                    <?php } ?>
                </div>
                <div class="nav_gallery_sing_prod">
                    <div class="img_wrap">
                        <img src="<?= esc_url($main_image_url) ?>" alt="<?= esc_attr($product->get_name()) ?>">
                    </div>
                    <?php
                    foreach ($gallery_image_ids as $image_id) {
                        $image_url = wp_get_attachment_url($image_id);
                        ?>

                        <div class="img_wrap">
                            <img src="<?= esc_url($image_url) ?>" alt="<?= esc_attr($product->get_name()) ?>">
                        </div>
                    <?php } ?>
                </div>
                <?php
                // Afișează imaginea principală

                /**
                 * Hook: woocommerce_before_single_product_summary.
                 *
                 * @hooked woocommerce_show_product_sale_flash - 10
                 * @hooked woocommerce_show_product_images - 20
                 */
                // do_action('woocommerce_before_single_product_summary');
                ?>
            </div>
            <div class="summary entry-summary">
                <?php
                /**
                 * Hook: woocommerce_single_product_summary.
                 *
                 * @hooked woocommerce_template_single_title - 5
                 * @hooked woocommerce_template_single_rating - 10
                 * @hooked woocommerce_template_single_price - 10
                 * @hooked woocommerce_template_single_excerpt - 20
                 * @hooked woocommerce_template_single_add_to_cart - 30
                 * @hooked woocommerce_template_single_meta - 40
                 * @hooked woocommerce_template_single_sharing - 50
                 * @hooked WC_Structured_Data::generate_product_data() - 60
                 */
                do_action('woocommerce_single_product_summary');
                $quantity_in_cart = 0;
                foreach (WC()->cart->get_cart() as $cart_item) {
                    if ($cart_item['product_id'] == $product_id) {
                        $quantity_in_cart = $cart_item['quantity'];
                        break;
                    }
                }
                ?>
                <div class="custom_add_to_cart_single_product">
                    <div class="add_quantity">
                        <p><?php echo pll_e('Cantitate') ?></p>
                        <div class="buttons">
                            <button class="add-to-cart-button" data-product-id="<?= $product_id ?>" data-quantity="1">+1
                            </button>
                            <button class="add-to-cart-button" data-product-id="<?= $product_id ?>" data-quantity="2">+2
                            </button>
                            <button class="add-to-cart-button" data-product-id="<?= $product_id ?>" data-quantity="3">+3
                            </button>
                            <button class="add-to-cart-button" data-product-id="<?= $product_id ?>" data-quantity="4">+4
                            </button>
                            <button class="add-to-cart-button" data-product-id="<?= $product_id ?>" data-quantity="5">+5
                            </button>
                            <button class="add-to-cart-button" data-product-id="<?= $product_id ?>" data-quantity="10">
                                +10
                            </button>
                        </div>
                    </div>
                    <div class="product-quantity-display">
                        <button class="quantity-minus" data-product-id="<?php echo esc_attr($product_id) ?>">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                 fill="none">
                                <path d="M3.74972 12.7495C3.33578 12.7495 3 12.4137 3 11.9997C3 11.5858 3.33578 11.25 3.74972 11.25H20.2495C20.6634 11.25 20.9992 11.5858 20.9992 11.9997C20.9992 12.4137 20.6634 12.7495 20.2495 12.7495H3.74972Z"
                                      fill="white"/>
                            </svg>
                        </button>
                        <input type="text" data-id="quantity_<?php echo esc_attr($product_id) ?>"
                               value="<?= $quantity_in_cart ?>"
                               readonly>
                        <button class="quantity-plus" data-product-id="<?php echo esc_attr($product_id) ?>">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                 fill="none">
                                <path d="M3.74973 12.7493C3.33578 12.7493 3 12.4135 3 11.9996C3 11.5857 3.33578 11.2499 3.74973 11.2499H11.2499V3.74973C11.2499 3.33578 11.5857 3 11.9996 3C12.4135 3 12.7493 3.33578 12.7493 3.74973V11.2499H20.2495C20.6634 11.2499 20.9992 11.5857 20.9992 11.9996C20.9992 12.4135 20.6634 12.7493 20.2495 12.7493H12.7493V20.2495C12.7493 20.6634 12.4135 20.9992 11.9996 20.9992C11.5857 20.9992 11.2499 20.6634 11.2499 20.2495V12.7493H3.74973Z"
                                      fill="white"/>
                            </svg>
                        </button>
                    </div>
                    <?php
                    if ($quantity_in_cart > 0) { ?>
                        <div class="product_notification_wrap active" data-product_id="<?php echo $product_id ?>">
                            <div class="product-notification">
                                <?php echo pll_e('Aveți') ?>
                                <b><?php echo $quantity_in_cart ?>&nbsp;</b><?php echo pll_e('produse în coș.') ?>
                            </div>
                            <button class="remove-from-cart-button custom_remove_button close"
                                    data-product_id="<?= $product_id ?>">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                     fill="none">
                                    <path d="M19.2807 18.2193C19.3504 18.289 19.4056 18.3717 19.4433 18.4628C19.4811 18.5538 19.5005 18.6514 19.5005 18.7499C19.5005 18.8485 19.4811 18.9461 19.4433 19.0371C19.4056 19.1281 19.3504 19.2109 19.2807 19.2806C19.211 19.3502 19.1283 19.4055 19.0372 19.4432C18.9462 19.4809 18.8486 19.5003 18.7501 19.5003C18.6515 19.5003 18.5539 19.4809 18.4629 19.4432C18.3718 19.4055 18.2891 19.3502 18.2194 19.2806L12.0001 13.0602L5.78068 19.2806C5.63995 19.4213 5.44907 19.5003 5.25005 19.5003C5.05103 19.5003 4.86016 19.4213 4.71943 19.2806C4.5787 19.1398 4.49963 18.949 4.49963 18.7499C4.49963 18.5509 4.5787 18.36 4.71943 18.2193L10.9397 11.9999L4.71943 5.78055C4.5787 5.63982 4.49963 5.44895 4.49963 5.24993C4.49963 5.05091 4.5787 4.86003 4.71943 4.7193C4.86016 4.57857 5.05103 4.49951 5.25005 4.49951C5.44907 4.49951 5.63995 4.57857 5.78068 4.7193L12.0001 10.9396L18.2194 4.7193C18.3602 4.57857 18.551 4.49951 18.7501 4.49951C18.9491 4.49951 19.1399 4.57857 19.2807 4.7193C19.4214 4.86003 19.5005 5.05091 19.5005 5.24993C19.5005 5.44895 19.4214 5.63982 19.2807 5.78055L13.0604 11.9999L19.2807 18.2193Z"
                                          fill="#F20030"/>
                                </svg>
                            </button>
                        </div>
                    <?php } else { ?>
                        <div class="product_notification_wrap" data-product_id="<?php echo $product_id ?>">
                            <div class="product-notification">
                                <?php echo pll_e('Aveți') ?>
                                <b><?php echo $quantity_in_cart ?>&nbsp;</b><?php echo pll_e('produse în coș.') ?>
                            </div>
                            <button class="remove-from-cart-button custom_remove_button close"
                                    data-product_id="<?= $product_id ?>">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"
                                     fill="none">
                                    <path d="M19.2807 18.2193C19.3504 18.289 19.4056 18.3717 19.4433 18.4628C19.4811 18.5538 19.5005 18.6514 19.5005 18.7499C19.5005 18.8485 19.4811 18.9461 19.4433 19.0371C19.4056 19.1281 19.3504 19.2109 19.2807 19.2806C19.211 19.3502 19.1283 19.4055 19.0372 19.4432C18.9462 19.4809 18.8486 19.5003 18.7501 19.5003C18.6515 19.5003 18.5539 19.4809 18.4629 19.4432C18.3718 19.4055 18.2891 19.3502 18.2194 19.2806L12.0001 13.0602L5.78068 19.2806C5.63995 19.4213 5.44907 19.5003 5.25005 19.5003C5.05103 19.5003 4.86016 19.4213 4.71943 19.2806C4.5787 19.1398 4.49963 18.949 4.49963 18.7499C4.49963 18.5509 4.5787 18.36 4.71943 18.2193L10.9397 11.9999L4.71943 5.78055C4.5787 5.63982 4.49963 5.44895 4.49963 5.24993C4.49963 5.05091 4.5787 4.86003 4.71943 4.7193C4.86016 4.57857 5.05103 4.49951 5.25005 4.49951C5.44907 4.49951 5.63995 4.57857 5.78068 4.7193L12.0001 10.9396L18.2194 4.7193C18.3602 4.57857 18.551 4.49951 18.7501 4.49951C18.9491 4.49951 19.1399 4.57857 19.2807 4.7193C19.4214 4.86003 19.5005 5.05091 19.5005 5.24993C19.5005 5.44895 19.4214 5.63982 19.2807 5.78055L13.0604 11.9999L19.2807 18.2193Z"
                                          fill="#F20030"/>
                                </svg>
                            </button>
                        </div>
                    <?php } ?>

                    <?php
                    $price = $product->get_price();
                    if ($quantity_in_cart > 0) {
                        $currency = get_woocommerce_currency();
                        ?>
                        <div class="subtotal_notification subtotal" data-product_id="<?php echo $product_id ?>">
                            <p><?php echo pll_e('Cat te costă acest produs?') ?></p>
                            <ul class="subtotal">
                                <li class="quantity"><?= $quantity_in_cart ?></li>
                                <li>&nbsp;x&nbsp;</li>
                                <li class="price_unit"><?= $price ?></li>
                                <li>&nbsp;=&nbsp;</li>
                                <li class="price"><b><?php echo $quantity_in_cart * $price ?>&nbsp;<?= $currency ?></b>
                                </li>
                            </ul>
                        </div>
                    <?php } else {
                        $currency = get_woocommerce_currency();
                        ?>
                        <div class="subtotal_notification subtotal" data-product_id="<?php echo $product_id ?>">
                            <p><?php echo pll_e('Cat te costă acest produs?') ?></p>
                            <ul class="subtotal">
                                <li class="quantity"><?= $quantity_in_cart ?></li>
                                <li>&nbsp;x&nbsp;</li>
                                <li class="price_unit"><?= $price ?></li>
                                <li>&nbsp;=&nbsp;</li>
                                <li class="price"><b><?php echo $quantity_in_cart * $price ?>&nbsp; <?= $currency ?></b>
                                </li>
                            </ul>
                        </div>
                    <?php } ?>
                </div>
            </div>
        </div>
    </div>
    <div class="modal" data-id="cooking_mode">
        <div class="modal_header">
            <h4><?php echo pll_e('Mod de preparare') ?></h4>
            <div class="close">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                    <path d="M19.2808 18.2193C19.3505 18.289 19.4058 18.3717 19.4435 18.4628C19.4812 18.5538 19.5006 18.6514 19.5006 18.7499C19.5006 18.8485 19.4812 18.9461 19.4435 19.0371C19.4058 19.1281 19.3505 19.2109 19.2808 19.2806C19.2111 19.3502 19.1284 19.4055 19.0373 19.4432C18.9463 19.4809 18.8487 19.5003 18.7502 19.5003C18.6516 19.5003 18.554 19.4809 18.463 19.4432C18.372 19.4055 18.2892 19.3502 18.2195 19.2806L12.0002 13.0602L5.7808 19.2806C5.64007 19.4213 5.4492 19.5003 5.25017 19.5003C5.05115 19.5003 4.86028 19.4213 4.71955 19.2806C4.57882 19.1398 4.49976 18.949 4.49976 18.7499C4.49976 18.5509 4.57882 18.36 4.71955 18.2193L10.9399 11.9999L4.71955 5.78055C4.57882 5.63982 4.49976 5.44895 4.49976 5.24993C4.49976 5.05091 4.57882 4.86003 4.71955 4.7193C4.86028 4.57857 5.05115 4.49951 5.25017 4.49951C5.4492 4.49951 5.64007 4.57857 5.7808 4.7193L12.0002 10.9396L18.2195 4.7193C18.3603 4.57857 18.5512 4.49951 18.7502 4.49951C18.9492 4.49951 19.1401 4.57857 19.2808 4.7193C19.4215 4.86003 19.5006 5.05091 19.5006 5.24993C19.5006 5.44895 19.4215 5.63982 19.2808 5.78055L13.0605 11.9999L19.2808 18.2193Z"
                          fill="white"/>
                </svg>
            </div>
        </div>
        <div class="modal_content">
            <?php the_field('mod_de_preparare') ?>
        </div>
        <div class="modal_footer">
            <span><?php echo pll_e('Închide') ?></span>
        </div>
    </div>
    <div class="modal" data-id="ingredients">
        <div class="modal_header">
            <h4><?php echo pll_e('Ingrediente') ?></h4>
            <div class="close">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                    <path d="M19.2808 18.2193C19.3505 18.289 19.4058 18.3717 19.4435 18.4628C19.4812 18.5538 19.5006 18.6514 19.5006 18.7499C19.5006 18.8485 19.4812 18.9461 19.4435 19.0371C19.4058 19.1281 19.3505 19.2109 19.2808 19.2806C19.2111 19.3502 19.1284 19.4055 19.0373 19.4432C18.9463 19.4809 18.8487 19.5003 18.7502 19.5003C18.6516 19.5003 18.554 19.4809 18.463 19.4432C18.372 19.4055 18.2892 19.3502 18.2195 19.2806L12.0002 13.0602L5.7808 19.2806C5.64007 19.4213 5.4492 19.5003 5.25017 19.5003C5.05115 19.5003 4.86028 19.4213 4.71955 19.2806C4.57882 19.1398 4.49976 18.949 4.49976 18.7499C4.49976 18.5509 4.57882 18.36 4.71955 18.2193L10.9399 11.9999L4.71955 5.78055C4.57882 5.63982 4.49976 5.44895 4.49976 5.24993C4.49976 5.05091 4.57882 4.86003 4.71955 4.7193C4.86028 4.57857 5.05115 4.49951 5.25017 4.49951C5.4492 4.49951 5.64007 4.57857 5.7808 4.7193L12.0002 10.9396L18.2195 4.7193C18.3603 4.57857 18.5512 4.49951 18.7502 4.49951C18.9492 4.49951 19.1401 4.57857 19.2808 4.7193C19.4215 4.86003 19.5006 5.05091 19.5006 5.24993C19.5006 5.44895 19.4215 5.63982 19.2808 5.78055L13.0605 11.9999L19.2808 18.2193Z"
                          fill="white"/>
                </svg>
            </div>
        </div>
        <div class="modal_content">
            <?php the_field('ingrediente') ?>
        </div>
        <div class="modal_footer">
            <span><?php echo pll_e('Închide') ?></span>
        </div>
    </div>
    <div class="modal" data-id="allergens">
        <div class="modal_header">
            <h4><?php echo pll_e('Alergeni') ?></h4>
            <div class="close">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                    <path d="M19.2808 18.2193C19.3505 18.289 19.4058 18.3717 19.4435 18.4628C19.4812 18.5538 19.5006 18.6514 19.5006 18.7499C19.5006 18.8485 19.4812 18.9461 19.4435 19.0371C19.4058 19.1281 19.3505 19.2109 19.2808 19.2806C19.2111 19.3502 19.1284 19.4055 19.0373 19.4432C18.9463 19.4809 18.8487 19.5003 18.7502 19.5003C18.6516 19.5003 18.554 19.4809 18.463 19.4432C18.372 19.4055 18.2892 19.3502 18.2195 19.2806L12.0002 13.0602L5.7808 19.2806C5.64007 19.4213 5.4492 19.5003 5.25017 19.5003C5.05115 19.5003 4.86028 19.4213 4.71955 19.2806C4.57882 19.1398 4.49976 18.949 4.49976 18.7499C4.49976 18.5509 4.57882 18.36 4.71955 18.2193L10.9399 11.9999L4.71955 5.78055C4.57882 5.63982 4.49976 5.44895 4.49976 5.24993C4.49976 5.05091 4.57882 4.86003 4.71955 4.7193C4.86028 4.57857 5.05115 4.49951 5.25017 4.49951C5.4492 4.49951 5.64007 4.57857 5.7808 4.7193L12.0002 10.9396L18.2195 4.7193C18.3603 4.57857 18.5512 4.49951 18.7502 4.49951C18.9492 4.49951 19.1401 4.57857 19.2808 4.7193C19.4215 4.86003 19.5006 5.05091 19.5006 5.24993C19.5006 5.44895 19.4215 5.63982 19.2808 5.78055L13.0605 11.9999L19.2808 18.2193Z"
                          fill="white"/>
                </svg>
            </div>
        </div>
        <div class="modal_content">
            <?php the_field('alergeni') ?>
        </div>
        <div class="modal_footer">
            <span><?php echo pll_e('Închide') ?></span>
        </div>
    </div>
    <div class="modal" data-id="storage">
        <div class="modal_header">
            <h4><?php echo pll_e('Condiții de păstrare') ?></h4>
            <div class="close">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                    <path d="M19.2808 18.2193C19.3505 18.289 19.4058 18.3717 19.4435 18.4628C19.4812 18.5538 19.5006 18.6514 19.5006 18.7499C19.5006 18.8485 19.4812 18.9461 19.4435 19.0371C19.4058 19.1281 19.3505 19.2109 19.2808 19.2806C19.2111 19.3502 19.1284 19.4055 19.0373 19.4432C18.9463 19.4809 18.8487 19.5003 18.7502 19.5003C18.6516 19.5003 18.554 19.4809 18.463 19.4432C18.372 19.4055 18.2892 19.3502 18.2195 19.2806L12.0002 13.0602L5.7808 19.2806C5.64007 19.4213 5.4492 19.5003 5.25017 19.5003C5.05115 19.5003 4.86028 19.4213 4.71955 19.2806C4.57882 19.1398 4.49976 18.949 4.49976 18.7499C4.49976 18.5509 4.57882 18.36 4.71955 18.2193L10.9399 11.9999L4.71955 5.78055C4.57882 5.63982 4.49976 5.44895 4.49976 5.24993C4.49976 5.05091 4.57882 4.86003 4.71955 4.7193C4.86028 4.57857 5.05115 4.49951 5.25017 4.49951C5.4492 4.49951 5.64007 4.57857 5.7808 4.7193L12.0002 10.9396L18.2195 4.7193C18.3603 4.57857 18.5512 4.49951 18.7502 4.49951C18.9492 4.49951 19.1401 4.57857 19.2808 4.7193C19.4215 4.86003 19.5006 5.05091 19.5006 5.24993C19.5006 5.44895 19.4215 5.63982 19.2808 5.78055L13.0605 11.9999L19.2808 18.2193Z"
                          fill="white"/>
                </svg>
            </div>
        </div>
        <div class="modal_content">
            <?php the_field('conditii_de_patrare') ?>
        </div>
        <div class="modal_footer">
            <span><?php echo pll_e('Închide') ?></span>
        </div>
    </div>
    <div class="modal" data-id="other">
        <div class="modal_header">
            <h4><?php echo pll_e('Altele') ?></h4>
            <div class="close">
                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
                    <path d="M19.2808 18.2193C19.3505 18.289 19.4058 18.3717 19.4435 18.4628C19.4812 18.5538 19.5006 18.6514 19.5006 18.7499C19.5006 18.8485 19.4812 18.9461 19.4435 19.0371C19.4058 19.1281 19.3505 19.2109 19.2808 19.2806C19.2111 19.3502 19.1284 19.4055 19.0373 19.4432C18.9463 19.4809 18.8487 19.5003 18.7502 19.5003C18.6516 19.5003 18.554 19.4809 18.463 19.4432C18.372 19.4055 18.2892 19.3502 18.2195 19.2806L12.0002 13.0602L5.7808 19.2806C5.64007 19.4213 5.4492 19.5003 5.25017 19.5003C5.05115 19.5003 4.86028 19.4213 4.71955 19.2806C4.57882 19.1398 4.49976 18.949 4.49976 18.7499C4.49976 18.5509 4.57882 18.36 4.71955 18.2193L10.9399 11.9999L4.71955 5.78055C4.57882 5.63982 4.49976 5.44895 4.49976 5.24993C4.49976 5.05091 4.57882 4.86003 4.71955 4.7193C4.86028 4.57857 5.05115 4.49951 5.25017 4.49951C5.4492 4.49951 5.64007 4.57857 5.7808 4.7193L12.0002 10.9396L18.2195 4.7193C18.3603 4.57857 18.5512 4.49951 18.7502 4.49951C18.9492 4.49951 19.1401 4.57857 19.2808 4.7193C19.4215 4.86003 19.5006 5.05091 19.5006 5.24993C19.5006 5.44895 19.4215 5.63982 19.2808 5.78055L13.0605 11.9999L19.2808 18.2193Z"
                          fill="white"/>
                </svg>
            </div>
        </div>
        <div class="modal_content">
            <?php the_field('altele') ?>
        </div>
        <div class="modal_footer">
            <span><?php echo pll_e('Închide') ?></span>
        </div>
    </div>
</div>

<?php get_template_part('section-recipes'); ?>
<?php get_template_part('section-newsletter'); ?>

<?php do_action('woocommerce_after_single_product'); ?>
