<?php
/**
 * Thankyou page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/thankyou.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 8.1.0
 *
 * @var WC_Order $order
 */

defined('ABSPATH') || exit;
?>
<div class="custom_header">
</div>
<div class="woocommerce-order">
    <h1 class="custom_title"><?php echo pll_e('Îți mulțumim. Am primit comanda ta.') ?></h1>
    <?php
    if ($order) :
        do_action('woocommerce_before_thankyou', $order->get_id()); ?>

        <?php
        if ($order->has_status('failed')) : ?>

            <p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed"><?php esc_html_e('Unfortunately your order cannot be processed as the originating bank/merchant has declined your transaction. Please attempt your purchase again.', 'woocommerce'); ?></p>

            <p class="woocommerce-notice woocommerce-notice--error woocommerce-thankyou-order-failed-actions">
                <a href="<?php echo esc_url($order->get_checkout_payment_url()); ?>"
                   class="button pay"><?php esc_html_e('Pay', 'woocommerce'); ?></a>
                <?php if (is_user_logged_in()) : ?>
                    <a href="<?php echo esc_url(wc_get_page_permalink('myaccount')); ?>"
                       class="button pay"><?php esc_html_e('My account', 'woocommerce'); ?></a>
                <?php endif; ?>
            </p>

        <?php else : ?>

            <?php wc_get_template('checkout/order-received.php', array('order' => $order)); ?>
            <ul class="woocommerce-order-overview woocommerce-thankyou-order-details order_details">

                <li class="woocommerce-order-overview__order order">
                    <?php esc_html_e('Order number:', 'woocommerce'); ?>
                    <strong><?php echo $order->get_order_number(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></strong>
                </li>

                <li class="woocommerce-order-overview__date date">
                    <?php esc_html_e('Date:', 'woocommerce'); ?>
                    <strong><?php echo wc_format_datetime($order->get_date_created()); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></strong>
                </li>

                <?php if (is_user_logged_in() && $order->get_user_id() === get_current_user_id() && $order->get_billing_email()) : ?>
                    <li class="woocommerce-order-overview__email email">
                        <?php esc_html_e('Email:', 'woocommerce'); ?>
                        <strong><?php echo $order->get_billing_email(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></strong>
                    </li>
                <?php endif; ?>

                <li class="woocommerce-order-overview__total total">
                    <?php esc_html_e('Total:', 'woocommerce'); ?>
                    <strong><?php echo $order->get_formatted_order_total(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></strong>
                </li>

                <?php if ($order->get_payment_method_title()) : ?>
                    <li class="woocommerce-order-overview__payment-method method">
                        <?php esc_html_e('Payment method:', 'woocommerce'); ?>
                        <strong><?php echo wp_kses_post($order->get_payment_method_title()); ?></strong>
                    </li>
                <?php endif; ?>

            </ul>

        <?php endif; ?>

    <?php else : ?>

        <?php wc_get_template('checkout/order-received.php', array('order' => false)); ?>

    <?php endif; ?>

    <?php
    add_action('wp_footer', 'populate_cf7_fields_on_thankyou');
    function populate_cf7_fields_on_thankyou()

    {
        if (!is_wc_endpoint_url('order-received')) {
            return;
        }

        // Obține ID-ul comenzii
        $order_id = absint(get_query_var('order-received'));
        if (!$order_id) return;

        $order = wc_get_order($order_id);
        if (!$order) return;

        $customer_name = $order->get_billing_first_name() . ' ' . $order->get_billing_last_name();
        $customer_email = $order->get_billing_email();
        $order_number = $order->get_order_number();
        ?>
        <script>
            document.addEventListener('DOMContentLoaded', function () {
                var orderField = document.getElementById('order_number');
                var nameField = document.getElementById('customer_name');
                var emailField = document.getElementById('customer_email');

                if (orderField) orderField.value = "<?php echo esc_js($order_number); ?>";
                if (nameField) nameField.value = "<?php echo esc_js($customer_name); ?>";
                if (emailField) emailField.value = "<?php echo esc_js($customer_email); ?>";
            });
        </script>
    <?php } ?>
    <div class="thank_you_custom_content">
        <div class="buttons">
            <a href="<?php echo pll_e('/magazin/') ?>"
               class="go_to_shop"><?php echo pll_e('Mergi la magazin') ?></a>
            <a class="download" target="_blank"
               href="<?php echo do_shortcode('[wcpdf_document_link]') ?>"><?php echo pll_e('Download order') ?></a>
        </div>
        <div class="survey">
            <div class="survey_header">
                <h2 class="title"><?php echo pll_e('Sondaj de Opinie') ?></h2>
                <h6><?php echo pll_e('Vom fi recunoscători pentru recenzii!') ?></h6>
            </div>
            <div class="survey_content">
                <?php echo do_shortcode('[contact-form-7 id="95d95df" title="Survey"]') ?>
            </div>
        </div>
    </div>
</div>


