<?php
/**
 * Review order table
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/review-order.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 5.2.0
 */

defined('ABSPATH') || exit;
?>
<div class="shop_table woocommerce-checkout-review-order-table">
    <ul class="review_checkout">
        <?php
        do_action('woocommerce_review_order_before_cart_contents');

        foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {
            $_product = apply_filters('woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key);
            $product_id = apply_filters('woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key);

            if ($_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters('woocommerce_checkout_cart_item_visible', true, $cart_item, $cart_item_key)) {
                $product_permalink = apply_filters('woocommerce_cart_item_permalink', $_product->is_visible() ? $_product->get_permalink($cart_item) : '', $cart_item, $cart_item_key);

                ?>
                <li class="<?php echo esc_attr(apply_filters('woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key)); ?>">
                    <div class="img_side">
                        <a href="<?php echo $product_permalink ?>" class="img_wrap">
                            <?php
                            $thumbnail = apply_filters('woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key);
                            echo $thumbnail; // PHPCS: XSS ok.
                            ?>
                        </a>
                    </div>
                    <div class="product-name">
                        <?php echo wp_kses_post(apply_filters('woocommerce_cart_item_name', $_product->get_name(), $cart_item, $cart_item_key)) . '&nbsp;'; ?>
                        <?php echo apply_filters('woocommerce_checkout_cart_item_quantity', ' <strong class="product-quantity">' . sprintf('&times;&nbsp;%s', $cart_item['quantity']) . '</strong>', $cart_item, $cart_item_key); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                        <?php echo wc_get_formatted_cart_item_data($cart_item); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                        <div class="quantity_wrap">
                            <div class="quantity">
                                <span class="button minus quantity-minus"
                                      data-product-id="<?php echo esc_attr($product_id) ?>">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="12" height="13" viewBox="0 0 12 13"
                                         fill="none">
                                        <path d="M1.87486 6.87473C1.66789 6.87473 1.5 6.70683 1.5 6.49986C1.5 6.29289 1.66789 6.125 1.87486 6.125H10.1247C10.3317 6.125 10.4996 6.29289 10.4996 6.49986C10.4996 6.70683 10.3317 6.87473 10.1247 6.87473H1.87486Z"
                                              fill="#222222"/>
                                    </svg>
                                </span>
                                <input type="number" readonly data-id="quantity_<?php echo esc_attr($product_id) ?>"
                                       value="<?= $cart_item['quantity'] ?>">
                                <span class="button plus quantity-plus mini_cart_plus"
                                      data-product-id="<?php echo esc_attr($product_id) ?>">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="12" height="13" viewBox="0 0 12 13"
                                         fill="none">
                                        <path d="M1.87486 6.87466C1.66789 6.87466 1.5 6.70677 1.5 6.4998C1.5 6.29283 1.66789 6.12494 1.87486 6.12494H5.62494V2.37486C5.62494 2.16789 5.79283 2 5.9998 2C6.20677 2 6.37466 2.16789 6.37466 2.37486V6.12494H10.1247C10.3317 6.12494 10.4996 6.29283 10.4996 6.4998C10.4996 6.70677 10.3317 6.87466 10.1247 6.87466H6.37466V10.6247C6.37466 10.8317 6.20677 10.9996 5.9998 10.9996C5.79283 10.9996 5.62494 10.8317 5.62494 10.6247V6.87466H1.87486Z"
                                              fill="#222222"/>
                                    </svg>
                                </span>
                            </div>
                        </div>
                    </div>
                    <div class="product-total">
                        <?php echo apply_filters('woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal($_product, $cart_item['quantity']), $cart_item, $cart_item_key); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
                    </div>
                </li>
                <?php
            }
        }

        ?>
    </ul>
    <ul class="checkout_options">
        <?php do_action('woocommerce_review_order_after_cart_contents'); ?>
        <li class="cart-subtotal">
            <div class="subtotal_text"><?php esc_html_e('Subtotal', 'woocommerce'); ?></div>
            <div class="subtotal_amount"><?php wc_cart_totals_subtotal_html(); ?></div>
        </li>
        <?php

        foreach (WC()->cart->get_coupons() as $code => $coupon) : ?>
            <li class="cart-discount coupon-<?php echo esc_attr(sanitize_title($code)); ?>">
                <span><?php wc_cart_totals_coupon_label($coupon); ?></span>
                <p><?php wc_cart_totals_coupon_html($coupon); ?></p>
                <div class="coupon_notification"><?php echo pll_e('Reducerea se aplică doar costului produselor, nu și livrării.') ?></div>
            </li>
        <?php endforeach; ?>
        <li class="shipping">
            <?php if (WC()->cart->needs_shipping() && WC()->cart->show_shipping()) : ?>

                <?php do_action('woocommerce_review_order_before_shipping'); ?>

                <?php wc_cart_totals_shipping_html(); ?>

                <?php do_action('woocommerce_review_order_after_shipping'); ?>

            <?php endif; ?>
        </li>
        <?php foreach (WC()->cart->get_fees() as $fee) : ?>
            <li class="fee">
                <span><?php echo esc_html($fee->name); ?></span>
                <p><?php wc_cart_totals_fee_html($fee); ?></p>
            </li>
        <?php endforeach; ?>

        <?php if (wc_tax_enabled() && !WC()->cart->display_prices_including_tax()) : ?>
            <?php if ('itemized' === get_option('woocommerce_tax_total_display')) : ?>
                <?php foreach (WC()->cart->get_tax_totals() as $code => $tax) : // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited ?>
                    <li class="tax-rate tax-rate-<?php echo esc_attr(sanitize_title($code)); ?>">
                        <span><?php echo esc_html($tax->label); ?></span>
                        <p><?php echo wp_kses_post($tax->formatted_amount); ?></p>
                    </li>
                <?php endforeach; ?>
            <?php else : ?>
                <li class="tax-total">
                    <span><?php echo esc_html(WC()->countries->tax_or_vat()); ?></span>
                    <p><?php wc_cart_totals_taxes_total_html(); ?></p>
                </li>
            <?php endif; ?>
        <?php endif; ?>

        <?php do_action('woocommerce_review_order_before_order_total'); ?>

        <li class="order-total">
            <span><?php esc_html_e('Total', 'woocommerce'); ?></span>
            <p><?php wc_cart_totals_order_total_html(); ?></p>
        </li>

        <?php do_action('woocommerce_review_order_after_order_total'); ?>

    </ul>
</div>
