<?php
/**
 * Template name: post
 * template post type: post
 */
?>
<?php get_header() ?>
<?php $ids = get_field('produs_asociat'); ?>
<div class="single_recipe_wrap">
    <div class="main_section_recipe">
        <div class="container">
            <div class="breadcrumbs">
                <div class="container">
                    <ul>
                        <li><a href="/">Promez</a></li>
                        <li>|</li>
                        <li><a href="<?php if (pll_current_language() == 'ro') {
                                echo "/ro/retete";
                            } elseif (pll_current_language() == 'en') {
                                echo "/en/recipes/";
                            } elseif (pll_current_language() == 'de') {
                                echo "/rezepten/";
                            } ?>"><?php echo pll_e('Rețete') ?></a>
                        </li>
                        <li>|</li>
                        <li><?php the_category(); ?></li>
                        <li>|</li>
                        <li><span><?php the_title() ?></span></li>
                    </ul>
                </div>
            </div>
            <div class="main_section_content">
                <?php
                if (has_post_thumbnail()) {
                    // Afișează imaginea reprezentativă
                    the_post_thumbnail('full'); // Poți schimba 'full' cu altă dimensiune ('thumbnail', 'medium', 'large')
                } else {
                    echo 'Acest articol nu are o imagine reprezentativă.';
                }
                ?>

                <div class="main_section_absolute">
                    <div class="left_side">
                        <h1><?php the_title() ?></h1>
                        <div class="short_desc"><?php the_content(); ?></div>
                        <div class="images">
                            <?php

                            $tags = wp_get_post_terms($ids[0], 'product_tag');

                            // Verifică fiecare etichetă și afișează iconița corespunzătoare
                            foreach ($tags as $tag) {

                                if ($tag->slug == 'beef') {
                                    echo '<img src="/wp-content/themes/victor-child/assets/img/beef.svg" alt="Beef" class="product-icon"/>';
                                }
                                if ($tag->slug == 'pork') {
                                    echo '<img src="/wp-content/themes/victor-child/assets/img/pork.svg" alt="Pork" class="product-icon"/>';
                                }
                                if ($tag->slug == 'sheep') {
                                    echo '<img src="/wp-content/themes/victor-child/assets/img/sheep.svg" alt="Sheep" class="product-icon"/>';
                                }
                                // Adaugă alte etichete și iconițe după nevoie
                            } ?>
                        </div>
                    </div>
                    <div class="right_side">
                        <div class="block">
                            <div>
                                <span><?php echo pll_e('Ingrediente') ?></span>
                                <p><?php the_field('number_of_ingredients') ?></p>
                            </div>
                            <svg xmlns="http://www.w3.org/2000/svg" width="32" height="32" viewBox="0 0 32 32"
                                 fill="none">
                                <path d="M29.9552 9.87757H25.3765C26.3669 11.5937 26.7633 13.5887 26.5042 15.5532C26.2451 17.5176 25.345 19.3416 23.9435 20.7423C22.7454 21.9643 21.1858 23.1216 19.4646 24.189C19.3569 24.2546 19.2302 24.282 19.105 24.267C18.9798 24.2519 18.8632 24.1952 18.7741 24.106L13.8747 19.2066C13.7682 19.1 13.6413 19.0159 13.5016 18.9593C13.3619 18.9027 13.2122 18.8748 13.0615 18.8771C12.9108 18.8795 12.7621 18.9121 12.6242 18.9731C12.4863 19.034 12.3621 19.1221 12.259 19.2319C12.0604 19.4547 11.9556 19.7455 11.9663 20.0437C11.9771 20.3419 12.1026 20.6244 12.3166 20.8323L16.5185 25.0341C16.5813 25.0968 16.6283 25.1734 16.6558 25.2577C16.6834 25.342 16.6906 25.4316 16.6768 25.5192C16.6631 25.6068 16.6289 25.69 16.5769 25.7618C16.525 25.8337 16.4568 25.8922 16.3779 25.9327C10.7936 28.8324 4.78333 30.766 3.90865 31.0388C3.49022 31.2337 3.02196 31.2953 2.56739 31.215C2.11281 31.1348 1.69391 30.9167 1.36751 30.5903C1.0411 30.2639 0.822991 29.845 0.742752 29.3904C0.662512 28.9358 0.724029 28.4676 0.918959 28.0491C1.30287 26.8243 4.99708 15.3549 10.0399 9.29679C10.09 9.23684 10.1521 9.188 10.2221 9.15336C10.2921 9.11873 10.3686 9.09906 10.4467 9.09562C10.5247 9.09218 10.6027 9.10504 10.6755 9.13338C10.7483 9.16172 10.8144 9.20492 10.8696 9.26022L16.7829 15.1749C16.8922 15.2842 17.023 15.3698 17.1669 15.4263C17.3108 15.4828 17.4649 15.5091 17.6194 15.5034C17.7739 15.4977 17.9256 15.4603 18.065 15.3933C18.2044 15.3264 18.3285 15.2315 18.4296 15.1144C18.6144 14.8913 18.7084 14.6068 18.6928 14.3175C18.6771 14.0282 18.553 13.7554 18.3452 13.5535L12.529 7.73725C12.4697 7.6782 12.4243 7.60665 12.3961 7.52782C12.368 7.449 12.3578 7.36489 12.3663 7.28162C12.3748 7.19836 12.4017 7.11803 12.4452 7.04651C12.4887 6.97499 12.5475 6.91407 12.6176 6.86819C14.0128 5.94717 15.6371 5.43299 17.3082 5.38332C18.9793 5.33364 20.6313 5.75042 22.0788 6.58694V2.00257C22.0785 1.84822 22.1099 1.69544 22.1711 1.55376C22.2323 1.41207 22.322 1.28449 22.4347 1.17897C22.5473 1.07345 22.6805 0.992234 22.8259 0.940382C22.9712 0.888529 23.1257 0.867147 23.2797 0.877566C23.5696 0.902787 23.8392 1.03694 24.0341 1.25301C24.2291 1.46907 24.3349 1.75098 24.3302 2.04194V6.0371L28.0343 2.33163C28.1388 2.2271 28.2629 2.14419 28.3995 2.08762C28.536 2.03106 28.6824 2.00194 28.8302 2.00194C28.978 2.00194 29.1244 2.03106 29.261 2.08762C29.3975 2.14419 29.5216 2.2271 29.6261 2.33163C29.7307 2.43615 29.8136 2.56024 29.8702 2.69681C29.9267 2.83338 29.9558 2.97975 29.9558 3.12757C29.9558 3.27539 29.9267 3.42176 29.8702 3.55832C29.8136 3.69489 29.7307 3.81898 29.6261 3.9235L25.9207 7.62757H29.9158C30.2068 7.62291 30.4887 7.72871 30.7048 7.92364C30.9208 8.11856 31.055 8.38813 31.0802 8.67804C31.0904 8.83192 31.0689 8.98626 31.017 9.13148C30.965 9.27669 30.8838 9.40967 30.7783 9.52216C30.6728 9.63465 30.5453 9.72425 30.4037 9.78539C30.2621 9.84653 30.1094 9.87791 29.9552 9.87757Z"
                                      fill="white"/>
                            </svg>
                        </div>
                        <div class="block">
                            <div>
                                <span><?php echo pll_e('Preparare') ?></span>
                                <p><?php the_field('cook_time') ?></p>
                            </div>
                            <svg xmlns="http://www.w3.org/2000/svg" width="33" height="31" viewBox="0 0 33 31"
                                 fill="none">
                                <path d="M7.33856 2.79656L2.83856 7.29656C2.62746 7.50766 2.34115 7.62625 2.04262 7.62625C1.74408 7.62625 1.45778 7.50766 1.24668 7.29656C1.03558 7.08547 0.916992 6.79916 0.916992 6.50063C0.916992 6.20209 1.03558 5.91578 1.24668 5.70469L5.74668 1.20469C5.95778 0.993592 6.24408 0.875 6.54262 0.875C6.84115 0.875 7.12746 0.993592 7.33856 1.20469C7.54965 1.41578 7.66824 1.70209 7.66824 2.00063C7.66824 2.29916 7.54965 2.58547 7.33856 2.79656ZM32.0886 5.70469L27.5886 1.20469C27.3775 0.993592 27.0912 0.875 26.7926 0.875C26.4941 0.875 26.2078 0.993592 25.9967 1.20469C25.7856 1.41578 25.667 1.70209 25.667 2.00063C25.667 2.29916 25.7856 2.58547 25.9967 2.79656L30.4967 7.29656C30.6012 7.40109 30.7253 7.484 30.8619 7.54057C30.9984 7.59714 31.1448 7.62625 31.2926 7.62625C31.4404 7.62625 31.5868 7.59714 31.7234 7.54057C31.8599 7.484 31.984 7.40109 32.0886 7.29656C32.1931 7.19204 32.276 7.06795 32.3326 6.93138C32.3891 6.79482 32.4182 6.64844 32.4182 6.50063C32.4182 6.35281 32.3891 6.20643 32.3326 6.06987C32.276 5.9333 32.1931 5.80921 32.0886 5.70469ZM30.1676 16.6256C30.1676 19.2957 29.3759 21.9058 27.8925 24.1258C26.4091 26.3459 24.3006 28.0762 21.8338 29.098C19.367 30.1198 16.6526 30.3871 14.0339 29.8662C11.4152 29.3453 9.00968 28.0596 7.12168 26.1716C5.23367 24.2836 3.94792 21.8781 3.42702 19.2593C2.90612 16.6406 3.17346 13.9262 4.19524 11.4594C5.21703 8.9926 6.94736 6.88418 9.16742 5.40079C11.3875 3.91739 13.9976 3.12563 16.6676 3.12563C20.2468 3.12972 23.6782 4.55335 26.209 7.08421C28.7399 9.61506 30.1635 13.0465 30.1676 16.6256ZM25.6676 16.6256C25.6676 16.3273 25.5491 16.0411 25.3381 15.8301C25.1271 15.6192 24.841 15.5006 24.5426 15.5006H17.7926V8.75063C17.7926 8.45226 17.6741 8.16611 17.4631 7.95513C17.2521 7.74415 16.966 7.62563 16.6676 7.62563C16.3692 7.62563 16.0831 7.74415 15.8721 7.95513C15.6611 8.16611 15.5426 8.45226 15.5426 8.75063V16.6256C15.5426 16.924 15.6611 17.2101 15.8721 17.4211C16.0831 17.6321 16.3692 17.7506 16.6676 17.7506H24.5426C24.841 17.7506 25.1271 17.6321 25.3381 17.4211C25.5491 17.2101 25.6676 16.924 25.6676 16.6256Z"
                                      fill="white"/>
                            </svg>
                        </div>
                        <div class="block">
                            <div>
                                <span><?php echo pll_e('Porții') ?></span>
                                <p><?php the_field('seves') ?></p>
                            </div>
                            <svg xmlns="http://www.w3.org/2000/svg" width="30" height="31" viewBox="0 0 30 31"
                                 fill="none">
                                <path d="M8.49891 5.23439C9.25125 4.29783 9.43687 3.66502 9.35953 3.38658C9.30047 3.17705 9.02062 3.06877 9.01781 3.06877C8.76316 2.98508 8.54675 2.81321 8.40758 2.58412C8.2684 2.35503 8.21559 2.08378 8.25867 1.81921C8.30175 1.55464 8.43788 1.31414 8.64254 1.14104C8.8472 0.967935 9.10695 0.873597 9.375 0.875016C9.48846 0.875149 9.60126 0.892212 9.70969 0.925641C9.85031 0.969235 11.1033 1.39392 11.5083 2.72002C11.8542 3.85486 11.4309 5.17392 10.2511 6.64205C9.49875 7.57861 9.31313 8.21142 9.39047 8.48986C9.44953 8.69939 9.72375 8.80486 9.72656 8.80627C9.98075 8.88981 10.1968 9.06122 10.336 9.28971C10.4752 9.51821 10.5284 9.78884 10.4861 10.053C10.4438 10.3172 10.3087 10.5577 10.105 10.7312C9.90139 10.9048 9.64256 11.0001 9.375 11C9.26154 10.9999 9.14874 10.9828 9.04031 10.9494C8.89969 10.9058 7.64672 10.4811 7.24172 9.15502C6.89578 8.02017 7.31906 6.70111 8.49891 5.23439ZM12.8667 9.15642C13.2717 10.4825 14.5247 10.9072 14.6653 10.9508C14.7738 10.9838 14.8866 11.0003 15 11C15.2676 11.0001 15.5264 10.9048 15.73 10.7312C15.9337 10.5577 16.0688 10.3172 16.1111 10.053C16.1534 9.78884 16.1002 9.51821 15.961 9.28971C15.8218 9.06122 15.6057 8.88981 15.3516 8.80627C15.3516 8.80627 15.0703 8.69939 15.0155 8.48986C14.9381 8.20861 15.1237 7.57861 15.8761 6.64205C17.0559 5.17392 17.4792 3.85486 17.1333 2.72002C16.7283 1.39392 15.4767 0.969235 15.3347 0.925641C15.2263 0.892212 15.1135 0.875149 15 0.875016C14.7327 0.874621 14.474 0.969412 14.2702 1.14241C14.0665 1.3154 13.931 1.55529 13.888 1.81911C13.845 2.08293 13.8974 2.35343 14.0357 2.58215C14.174 2.81088 14.3892 2.98289 14.6428 3.06736C14.6428 3.06736 14.9241 3.17564 14.9845 3.38517C15.0619 3.66642 14.8762 4.29642 14.1239 5.23298C12.9441 6.70111 12.5208 8.02017 12.8667 9.15502V9.15642ZM18.4917 9.15642C18.8967 10.4825 20.1497 10.9072 20.2903 10.9508C20.3988 10.9838 20.5116 11.0003 20.625 11C20.8926 11.0001 21.1514 10.9048 21.355 10.7312C21.5587 10.5577 21.6938 10.3172 21.7361 10.053C21.7784 9.78884 21.7252 9.51821 21.586 9.28971C21.4468 9.06122 21.2307 8.88981 20.9766 8.80627C20.9766 8.80627 20.6953 8.69939 20.6405 8.48986C20.5631 8.20861 20.7487 7.57861 21.5011 6.64205C22.6809 5.17392 23.1042 3.85486 22.7583 2.72002C22.3533 1.39392 21.1017 0.969235 20.9597 0.925641C20.8513 0.892212 20.7385 0.875149 20.625 0.875016C20.3577 0.874621 20.099 0.969412 19.8952 1.14241C19.6915 1.3154 19.556 1.55529 19.513 1.81911C19.47 2.08293 19.5224 2.35343 19.6607 2.58215C19.799 2.81088 20.0142 2.98289 20.2678 3.06736C20.2678 3.06736 20.5491 3.17564 20.6095 3.38517C20.6869 3.66642 20.5013 4.29642 19.7489 5.23298C18.5691 6.70111 18.1458 8.02017 18.4917 9.15502V9.15642ZM28.5 13.25H1.5C1.20163 13.25 0.915483 13.3685 0.704505 13.5795C0.493526 13.7905 0.375 14.0766 0.375 14.375C0.379943 17.0504 1.11622 19.6736 2.50422 21.9608C3.89221 24.248 5.8791 26.1123 8.25 27.3519V27.875C8.25 28.4718 8.48705 29.044 8.90901 29.466C9.33097 29.888 9.90326 30.125 10.5 30.125H19.5C20.0967 30.125 20.669 29.888 21.091 29.466C21.5129 29.044 21.75 28.4718 21.75 27.875V27.3519C24.1209 26.1123 26.1078 24.248 27.4958 21.9608C28.8838 19.6736 29.6201 17.0504 29.625 14.375C29.625 14.0766 29.5065 13.7905 29.2955 13.5795C29.0845 13.3685 28.7984 13.25 28.5 13.25Z"
                                      fill="white"/>
                            </svg>
                        </div>

                    </div>
                </div>
                <div class="top_buttons">
                    <a href="#" class="receipt_share">
                        <svg xmlns="http://www.w3.org/2000/svg" width="35" height="40" viewBox="0 0 64 64">
                            <g fill="white" id="Layer_100" data-name="Layer 100">
                                <path d="M44.84,10.5H24.9a5,5,0,0,0-5,5V42.8a5,5,0,0,0,5,5H44.84a5,5,0,0,0,5-5V15.46A5,5,0,0,0,44.84,10.5Zm2,32.3a2,2,0,0,1-2,2H24.9a2,2,0,0,1-2-2V15.46a2,2,0,0,1,2-2H44.84a2,2,0,0,1,2,2Z"/>
                                <path d="M39.07,50.5H19.18a2,2,0,0,1-2-2V21.23a1.5,1.5,0,0,0-3,0V48.51a5,5,0,0,0,5,5H39.07A1.5,1.5,0,0,0,39.07,50.5Z"/>
                            </g>
                        </svg>
                    </a>
                    <div class="tooltip"><?php echo pll_e('Link copiat!') ?></div>
                    <a href="<?php the_field('recipe_pdf') ?>" download="<?php the_title() ?>">
                        <svg xmlns="http://www.w3.org/2000/svg" width="35" height="40" viewBox="0 0 35 40" fill="none">
                            <path d="M33.6329 11.4007L23.086 0.853795C22.946 0.713922 22.7798 0.603008 22.5969 0.52739C22.414 0.451772 22.2179 0.412931 22.02 0.413086H3.93966C3.14046 0.413086 2.37399 0.730568 1.80887 1.29569C1.24375 1.86081 0.92627 2.62728 0.92627 3.42648V36.5738C0.92627 37.373 1.24375 38.1395 1.80887 38.7046C2.37399 39.2697 3.14046 39.5872 3.93966 39.5872H31.0602C31.8594 39.5872 32.6259 39.2697 33.191 38.7046C33.7561 38.1395 34.0736 37.373 34.0736 36.5738V12.4667C34.0737 12.2687 34.0349 12.0727 33.9593 11.8898C33.8837 11.7069 33.7728 11.5407 33.6329 11.4007ZM23.086 27.0929L18.5659 31.613C18.426 31.7531 18.2598 31.8642 18.0769 31.94C17.894 32.0159 17.6979 32.0549 17.4999 32.0549C17.3019 32.0549 17.1059 32.0159 16.923 31.94C16.74 31.8642 16.5739 31.7531 16.4339 31.613L11.9139 27.0929C11.6311 26.8102 11.4723 26.4267 11.4723 26.0269C11.4723 25.6271 11.6311 25.2437 11.9139 24.9609C12.1966 24.6782 12.58 24.5194 12.9798 24.5194C13.3797 24.5194 13.7631 24.6782 14.0458 24.9609L15.9932 26.9102V18.4934C15.9932 18.0938 16.152 17.7106 16.4345 17.428C16.7171 17.1455 17.1003 16.9867 17.4999 16.9867C17.8995 16.9867 18.2828 17.1455 18.5653 17.428C18.8479 17.7106 19.0066 18.0938 19.0066 18.4934V26.9102L20.954 24.9609C21.2368 24.6782 21.6202 24.5194 22.02 24.5194C22.4198 24.5194 22.8033 24.6782 23.086 24.9609C23.3687 25.2437 23.5276 25.6271 23.5276 26.0269C23.5276 26.4267 23.3687 26.8102 23.086 27.0929ZM22.02 12.4667V4.17983L30.3069 12.4667H22.02Z"
                                  fill="white"/>
                        </svg>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <div class="ingredients_wrap">
        <h2><?php echo pll_e('Ingrediente') ?></h2>
        <div class="container">
            <div class="ingredients">
                <div class="ingredients_list">
                    <?php
                    $product = wc_get_product($ids[0]);
                    ?>
                    <label>
                        <input type="checkbox">
                        <span><?php echo $product->get_name() ?></span>
                        <button class="add-to-cart-button" data-product-id="<?php echo $product->get_id() ?>"
                                data-quantity="1" data-stock="616">
                            <?php echo pll_e('Cumpără') ?>
                        </button>
                    </label>
                    <?php
                    if (have_rows('ingredients')):
                        while (have_rows('ingredients')) : the_row(); ?>
                            <label>
                                <input type="checkbox">
                                <span><?php the_sub_field('ingredient') ?></span>
                            </label>
                        <?php endwhile;
                    endif; ?>
                </div>
                <div class="associate_product">
                    <div class="product">
                        <?php
                        $args = array(
                            'post_type' => 'product',
                            'post__in' => $ids,
                            'posts_per_page' => 1,
                            'orderby' => 'rand'
                        );
                        $loop = new WP_Query($args);
                        if ($loop->have_posts()) {
                            while ($loop->have_posts()) : $loop->the_post();
                                wc_get_template_part('content', 'product');
                                echo '</div>';
                            endwhile;
                        }
                        wp_reset_postdata();
                        ?>
                        <span class="big_text"><?php echo pll_e('Descoperă acum savoarea micilor Promez!') ?></span>

                    </div><!--/.products-->
                </div>
            </div>
        </div>
        <div class="cooking_steps">
            <h2><?php echo pll_e('Mod de preparare') ?></h2>
            <div class="container">
                <?php
                if (have_rows('cooking_steps')):
                    while (have_rows('cooking_steps')) : the_row(); ?>
                        <div class="single_step">
                            <input type="checkbox" id="step<?php echo get_row_index(); ?>">
                            <label for="step<?php echo get_row_index(); ?>">
                                <p class="index"><?php echo get_row_index(); ?></p>
                                <span><?php the_sub_field('cooking_step') ?></span>
                            </label>
                        </div>
                    <?php endwhile;
                endif; ?>
            </div>
        </div>
        <div class="related_recipes_wrap">
            <h2><?php echo pll_e('Alte rețete') ?></h2>
            <div class="container">
                <div class="related_recipes">
                    <?php
                    $current_post_id = get_the_ID();
                    $current_post_categories = wp_get_post_categories($current_post_id); ?>
                    <?php $paged = (get_query_var('paged')) ? get_query_var('paged') : 1; ?>
                    <?php
                    $data = new WP_Query(array(
                        'post_type' => 'post', // your post type name
                        'posts_per_page' => 3, // post per page
                        'paged' => $paged,
                        'order' => 'ASC',
                        'post__not_in' => array($current_post_id),
                    ));
                    if ($data->have_posts()) :
                        while ($data->have_posts())  :
                            $data->the_post();
                            global $post; ?>
                            <a href="<?php echo get_permalink() ?>" class="single_project">
                                <div class="single_block">
                                    <div class="img_block">
                                        <?php if (has_post_thumbnail($data->ID)): ?>
                                            <?php $image = wp_get_attachment_image_src(get_post_thumbnail_id($data->ID), 'single-post-thumbnail'); ?>
                                            <img src="<?php echo $image[0]; ?>" alt="" class="event-icon">
                                        <?php endif; ?>
                                    </div>
                                    <div class="content">
                                        <div class="badge"><?php echo pll_e('Rețetă nouă') ?></div>
                                        <h4 class="title"><?= the_title() ?></h4>
                                        <div class="short_desc">
                                            <p><?php echo wp_trim_words(get_the_excerpt(), 20); // Afișează un rezumat de 20 de cuvinte
                                                ?></p>
                                        </div>
                                        <div class="recipe_by">
                                            <p><?php echo pll_e('Rețetă de') ?></p>
                                            <span><?php the_field('recipe_by') ?></span>
                                        </div>
                                    </div>
                                </div>
                            </a>
                        <?php endwhile; ?>
                    <?php endif;
                    wp_reset_postdata();
                    ?>
                </div>
            </div>
        </div>
        <?php get_template_part('section-newsletter'); ?>

        <?php get_footer() ?>
