jQuery(function ($) {
    $(document).ready(function () {

        // Formular de logare AJAX
        $('#ajaxLoginForm').on('submit', function (e) {
            e.preventDefault();
            $('#loading-spinner').show();

            var formData = {
                'action': 'ajax_login',
                'username': $('input[name="username"]').val(),
                'password': $('input[name="password"]').val(),
            };
            $.post('/wp-admin/admin-ajax.php', formData, function (response) {
                if (response.success) {
                    // $('#loginMessage').css('color', 'green').text(myLoginI18n.login_success);
                    window.location.reload(); // Reîncărcare pentru actualizarea statusului utilizatorului
                    $('#loading-spinner').hide();

                } else {
                    $('#loginMessage').html(response.data);
                    console.log(response)
                    $('#loading-spinner').hide();
                }
            });
        });


        // Formular de înregistrare AJAX
        $('#ajaxRegisterForm').on('submit', function (e) {
            e.preventDefault();
            $('#loading-spinner').show();
            var formData = {
                'action': 'ajax_register',
                'first_name': $('#ajaxRegisterForm input[name="first_name"]').val(),
                'last_name': $('#ajaxRegisterForm input[name="last_name"]').val(),
                'email': $('#ajaxRegisterForm input[name="email"]').val(),
                'password': $('#ajaxRegisterForm input[name="password"]').val(),
                'confirm_password': $('#ajaxRegisterForm input[name="confirm_password"]').val(),
                'birth_day': $('select[name="birth_day"]').val(),
                'birth_month': $('select[name="birth_month"]').val(),
                'birth_year': $('select[name="birth_year"]').val(),
                'subscribe_to_newsletter': $('#subscribe_to_newsletter').is(':checked') ? 1 : 0,
            };
            $.post('/wp-admin/admin-ajax.php', formData, function (response) {
                console.log(response)
                if (response.success) {
                    $('#registerMessage').addClass('active');
                    setTimeout(function () {
                        window.location.reload();
                    }, 1000)
                    $('#register_error_message').hide();
                    $('#loading-spinner').hide();
                } else {
                    $('#register_error_message').text(response.data);
                    $('#loading-spinner').hide();
                }
            })
        });

        // Request reset Password
        $('.lost_password').on('click', function (e) {
            e.preventDefault()
            $('.login_modal').removeClass('active');
        });

        $('.lost_password').on('click', function () {
            $('.request_reset_modal').addClass('active');
        });

        // Închide modalul
        $('.request_reset .close, .form_footer span').on('click', function () {
            $('.request_reset_modal').removeClass('active');
        });


        // Formular AJAX pentru recuperare parolă
        $('#reset-password-form').on('submit', function (e) {
            e.preventDefault();
            let email = $('#reset-email').val();
            $('#loading-spinner').css('display', 'flex');

            $.ajax({
                url: '/wp-admin/admin-ajax.php', // URL-ul din WordPress pentru AJAX
                type: 'POST', data: {
                    action: 'reset_password_request', email: email
                }, success: function (response) {
                    $('#loading-spinner').css('display', 'none');

                    if (response.success) {
                        $('#reset-password-message').html(`<span style="color: green;">${response.data.message}</span>`);

                    } else {
                        $('#reset-password-message').html(`<span style="color: red;">${response.data.message}</span>`);
                    }
                }, error: function () {
                    $('#reset-password-message').html('A apărut o eroare. Încearcă din nou.');
                }
            });
        });


        // Dupa accesarea link-ului din email si introducerea parolei noi

        // Închide modalul
        $('.reset_modal .close, .form_footer span').on('click', function () {
            $('.reset_modal').removeClass('active');
        });

        // Detectează parametrii URL
        const urlParams = new URLSearchParams(window.location.search);
        if (urlParams.has('action') && urlParams.get('action') === 'reset_password') {
            const key = urlParams.get('key');
            const login = urlParams.get('login');

            // Deschide modalul pentru resetarea parolei
            $('.reset_modal').addClass('active');

            // Salvează datele în câmpuri ascunse pentru trimiterea prin AJAX
            $('#reset-key').val(key);
            $('#reset-login').val(login);
        }


        // Formular AJAX pentru resetarea parolei
        $('#new-password-form').on('submit', function (e) {
            e.preventDefault();
            let password = $('#new-password').val();
            let confirmPassword = $('#confirm-password').val();
            let key = $('#reset-key').val();
            let login = $('#reset-login').val();


            if (password !== confirmPassword) {
                $('#reset-password-message').html('Parolele nu coincid.');
                return;
            }


            $.ajax({
                url: '/wp-admin/admin-ajax.php', type: 'POST', data: {
                    action: 'reset_password', password: password, key: key, login: login
                }, success: function (response) {
                    console.log(response)
                    $('#reset-password-message').html(response.message);
                    if (response.success) {
                        setTimeout(function () {
                            window.location.href = '/';
                        }, 3000); // Redirecționare după succes
                    }
                }, error: function () {
                    $('#reset-password-message').html('A apărut o eroare. Încearcă din nou.');
                }
            });
        });

    })
})