<?php

namespace PhpUnitsOfMeasureTest\PhysicalQuantity;

use PhpUnitsOfMeasure\PhysicalQuantity\ElectricCurrent;
use PhpUnitsOfMeasure\PhysicalQuantityInterface;

class ElectricCurrentTest extends AbstractPhysicalQuantityTestCase
{
    protected array $supportedUnitsWithAliases = [
        'A',
        'amp',
        'amps',
        'ampere',
        'amperes',
        'YA',
        'yottaamp',
        'yottaamps',
        'yottaampere',
        'yottaamperes',
        'ZA',
        'zettaamp',
        'zettaamps',
        'zettaampere',
        'zettaamperes',
        'EA',
        'exaamp',
        'exaamps',
        'exaampere',
        'exaamperes',
        'PA',
        'petaamp',
        'petaamps',
        'petaampere',
        'petaamperes',
        'TA',
        'teraamp',
        'teraamps',
        'teraampere',
        'teraamperes',
        'GA',
        'gigaamp',
        'gigaamps',
        'gigaampere',
        'gigaamperes',
        'MA',
        'megaamp',
        'megaamps',
        'megaampere',
        'megaamperes',
        'kA',
        'kiloamp',
        'kiloamps',
        'kiloampere',
        'kiloamperes',
        'hA',
        'hectoamp',
        'hectoamps',
        'hectoampere',
        'hectoamperes',
        'daA',
        'decaamp',
        'decaamps',
        'decaampere',
        'decaamperes',
        'dA',
        'deciamp',
        'deciamps',
        'deciampere',
        'deciamperes',
        'cA',
        'centiamp',
        'centiamps',
        'centiampere',
        'centiamperes',
        'mA',
        'milliamp',
        'milliamps',
        'milliampere',
        'milliamperes',
        'µA',
        'microamp',
        'microamps',
        'microampere',
        'microamperes',
        'nA',
        'nanoamp',
        'nanoamps',
        'nanoampere',
        'nanoamperes',
        'pA',
        'picoamp',
        'picoamps',
        'picoampere',
        'picoamperes',
        'fA',
        'femtoamp',
        'femtoamps',
        'femtoampere',
        'femtoamperes',
        'aA',
        'attoamp',
        'attoamps',
        'attoampere',
        'attoamperes',
        'zA',
        'zeptoamp',
        'zeptoamps',
        'zeptoampere',
        'zeptoamperes',
        'yA',
        'yoctoamp',
        'yoctoamps',
        'yoctoampere',
        'yoctoamperes',
    ];

    protected function instantiateTestQuantity(): PhysicalQuantityInterface
    {
        return new ElectricCurrent(1, 'A');
    }
}
